/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.rsf;

import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.xfw.updates.UpdateRange;
import java.text.NumberFormat;

public class RsfUpdateRange
implements PersistentData {
    private final int version = 0;
    private static final long serialVersionUID = 1L;
    private String ecIdentifier;
    private int currentLevel;
    private int requestedLevel;
    private static NumberFormat nf3 = NumberFormat.getInstance();

    public RsfUpdateRange(String ec_id, int currentLevel, int lastLevel) throws IllegalArgumentException {
        if (ec_id == null) {
            throw new IllegalArgumentException("ec_id is null");
        }
        this.requestedLevel = lastLevel;
        this.ecIdentifier = ec_id;
        this.currentLevel = currentLevel;
    }

    public RsfUpdateRange(UpdateRange range) throws IllegalArgumentException {
        if (range == null) {
            throw new IllegalArgumentException("input UpdateRange is null");
        }
        this.requestedLevel = range.getLastLevel();
        this.ecIdentifier = range.getUpdateableComponentECNumber();
        this.currentLevel = range.getFirstLevel();
        if (this.currentLevel < 1 || this.requestedLevel < this.currentLevel && this.requestedLevel != -1) {
            throw new IllegalArgumentException("invalid range: low = [" + this.currentLevel + "] high = [" + this.requestedLevel + "]");
        }
        --this.currentLevel;
    }

    public RsfUpdateRange(String ec_id, int ccl) throws IllegalArgumentException {
        if (ec_id == null) {
            throw new IllegalArgumentException("ec_id is null");
        }
        this.requestedLevel = -1;
        this.ecIdentifier = ec_id;
        this.currentLevel = ccl;
    }

    public int getVersion() {
        return 0;
    }

    public String getEcIdentifier() {
        return this.ecIdentifier;
    }

    public int getCurrentLevel() {
        return this.currentLevel;
    }

    public int getLastLevel() {
        return this.requestedLevel;
    }

    public boolean equals(Object o) {
        return o != null && o instanceof RsfUpdateRange && (this.ecIdentifier == ((RsfUpdateRange)o).ecIdentifier || this.ecIdentifier.equals(((RsfUpdateRange)o).ecIdentifier)) && this.currentLevel == ((RsfUpdateRange)o).currentLevel && this.requestedLevel == ((RsfUpdateRange)o).requestedLevel;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toXmlTransferFormat() {
        StringBuffer buffer = new StringBuffer("<MC><ID>");
        buffer.append(this.ecIdentifier);
        buffer.append("</ID><CL>");
        buffer.append(nf3.format(this.currentLevel));
        buffer.append("</CL><RL>");
        if (this.requestedLevel == -1) {
            buffer.append("ALL");
        } else {
            buffer.append(nf3.format(this.requestedLevel));
        }
        buffer.append("</RL></MC>");
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(" <MC><ID>");
        buffer.append(this.ecIdentifier);
        buffer.append("</ID><CL>");
        buffer.append(nf3.format(this.currentLevel));
        buffer.append("</CL><RL>");
        if (this.requestedLevel == -1) {
            buffer.append("ALL");
        } else {
            buffer.append(nf3.format(this.requestedLevel));
        }
        buffer.append("</RL></MC>\n");
        return buffer.toString();
    }

    static {
        nf3.setMinimumIntegerDigits(3);
    }
}

